/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks.wood;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.capability.size.IItemSize;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.dries007.tfc.api.types.Tree;
import net.dries007.tfc.objects.te.TEToolRack;
import net.dries007.tfc.util.Helpers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
public class BlockToolRack
extends Block
implements IItemSize {
    protected static final AxisAlignedBB RACK_EAST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.125, 1.0, 1.0);
    protected static final AxisAlignedBB RACK_WEST_AABB = new AxisAlignedBB(0.875, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB RACK_SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.125);
    protected static final AxisAlignedBB RACK_NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.875, 1.0, 1.0, 1.0);
    public final Tree wood;

    public BlockToolRack(Tree wood) {
        super(Material.field_151575_d, MapColor.field_151660_b);
        this.wood = wood;
        this.func_149672_a(SoundType.field_185848_a);
        this.setHarvestLevel("axe", 0);
        this.func_149711_c(0.5f);
        this.func_149752_b(3.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.NORTH));
    }

    @Override
    @Nonnull
    public Size getSize(@Nonnull ItemStack stack) {
        return Size.LARGE;
    }

    @Override
    @Nonnull
    public Weight getWeight(@Nonnull ItemStack stack) {
        return Weight.VERY_HEAVY;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D)).func_176736_b();
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D)) {
            default: {
                return RACK_NORTH_AABB;
            }
            case SOUTH: {
                return RACK_SOUTH_AABB;
            }
            case WEST: {
                return RACK_WEST_AABB;
            }
            case EAST: 
        }
        return RACK_EAST_AABB;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        if (!Helpers.canHangAt(worldIn, pos, (EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D))) {
            this.func_176226_b(worldIn, pos, state, 0);
            TEToolRack te = Helpers.getTE((IBlockAccess)worldIn, pos, TEToolRack.class);
            if (te != null) {
                te.onBreakBlock();
            }
            worldIn.func_175698_g(pos);
        }
    }

    public void func_180663_b(World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TEToolRack te = Helpers.getTE((IBlockAccess)worldIn, pos, TEToolRack.class);
        if (te != null) {
            te.onBreakBlock();
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_176196_c(World worldIn, @Nonnull BlockPos pos) {
        return super.func_176196_c(worldIn, pos) && Helpers.getASolidFacing(worldIn, pos, null, EnumFacing.field_176754_o) != null;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TEToolRack te;
        if (!worldIn.field_72995_K && (te = Helpers.getTE((IBlockAccess)worldIn, pos, TEToolRack.class)) != null) {
            return te.onRightClick(playerIn, hand, this.getSlotFromPos(state, hitX, hitY, hitZ));
        }
        return true;
    }

    @Nonnull
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            facing = placer.func_174811_aO().func_176734_d();
        }
        return this.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)Helpers.getASolidFacing(worldIn, pos, facing, EnumFacing.field_176754_o));
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockHorizontal.field_185512_D});
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TEToolRack();
    }

    @Nonnull
    public ItemStack getPickBlock(IBlockState state, @Nullable RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        if (target != null) {
            ItemStack item;
            Vec3d vec = target.field_72307_f.func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            TEToolRack te = Helpers.getTE((IBlockAccess)world, pos, TEToolRack.class);
            if (te != null && !(item = (ItemStack)te.getItems().get(this.getSlotFromPos(state, (float)vec.field_72450_a, (float)vec.field_72448_b, (float)vec.field_72449_c))).func_190926_b()) {
                return item;
            }
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public int getSlotFromPos(IBlockState state, float x, float y, float z) {
        int slot = 0;
        float f = ((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D)).func_176740_k().equals((Object)EnumFacing.Axis.Z) ? x : z;
        if (f > 0.5f) {
            ++slot;
        }
        if (y < 0.5f) {
            slot += 2;
        }
        return slot;
    }
}

